using System;
using System.Text;

namespace com.swvoyages.reservation {

	///
	/// <summary>La classe <code>Reservation</code> gre les informations 
	/// d'une rservation prise en charge par le systme de rservation 
	/// de la centrale de rservation.</summary>
	///
	public class Reservation {
		
		private static Random idGenerator = new Random();

		private int id = 0;

		private int passengers = 0;
		private String from = "";
		private String to = "";
		private bool roundTrip = false;
		private int departureDay = 0;
		private int departureMonth = 0;
		private int departureYear = 0;
		private int arrivalDay = 0;
		private int arrivalMonth = 0;
		private int arrivalYear = 0;

		private int remoteAirReservationId = 0;
		private int remoteCarReservationId = 0;
		private int remoteHotelReservationId = 0;
		
		private AirAvailability[] airAvailabilities = new AirAvailability[0];
		private CarAvailability[] carAvailabilities = new CarAvailability[0];
		private HotelAvailability[] hotelAvailabilities = new HotelAvailability[0];

		///
		/// <summary>Le constructeur de rservation.</summary>
		///
		public Reservation() {
			this.id = Id;
		}

		///
		/// <summary>Renvoie l'identifiant de la rservation.</summary>
		///
		public int Id {
			get {
				lock(this) {
					if (id == 0) {
						id = idGenerator.Next();
					}
					return id;
				}
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la rservation
		/// de la centrale de rservation arienne.</summary>
		///
		public int RemoteAirReservationId {
			get {
				return remoteAirReservationId;
			}
			set {
				this.remoteAirReservationId = value;
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la rservation
		/// de la centrale de rservation automobile.</summary>
		///
		public int RemoteCarReservationId {
			get {
				return remoteCarReservationId;
			}
			set {
				this.remoteCarReservationId = value;
			}
		}

		///
		/// <summary>Accesseurs de l'identifiant de la rservation
		/// de la centrale de rservation htelire.</summary>
		///
		public int RemoteHotelReservationId {
			get {
				return remoteHotelReservationId;
			}
			set {
				this.remoteHotelReservationId = value;
			}
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit de 
		/// la centrale de rservation arienne associe  la 
		/// disponibilit locale dont l'identifiant est pass
		/// en paramtre.</summary>
		///
		public int getRemoteAirAvailabilityId(int availabilityId) {

			AirAvailability[] availabilities = this.AirAvailabilities;
			for(int i=0; i<availabilities.Length; i++) {
				AirAvailability availability = availabilities[i];
				if (availability.id==availabilityId) {
					return availability.remoteId;
				}
			}
			throw new ReservationException("disponibilit du partenaire non trouve");
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit de 
		/// la centrale de rservation automobile associe  la 
		/// disponibilit locale dont l'identifiant est pass
		/// en paramtre.</summary>
		///
		public int getRemoteCarAvailabilityId(int availabilityId) {

			CarAvailability[] availabilities = this.CarAvailabilities;
			for(int i=0; i<availabilities.Length; i++) {
				CarAvailability availability = availabilities[i];
				if (availability.id==availabilityId) {
					return availability.remoteId;
				}
			}
			throw new ReservationException("disponibilit du partenaire non trouve");
		}

		///
		/// <summary>Renvoie l'identifiant de la disponibilit de 
		/// la centrale de rservation htelire associe  la 
		/// disponibilit locale dont l'identifiant est pass
		/// en paramtre.</summary>
		///
		public int getRemoteHotelAvailabilityId(int availabilityId) {

			HotelAvailability[] availabilities = this.HotelAvailabilities;
			for(int i=0; i<availabilities.Length; i++) {
				HotelAvailability availability = availabilities[i];
				if (availability.id==availabilityId) {
					return availability.remoteId;
				}
			}
			throw new ReservationException("disponibilit du partenaire non trouve");
		}

		///
		/// <summary>Accesseurs des disponibilits de la centrale de
		/// rservation arienne associe  cette rservation.</summary>
		///
		public AirAvailability[] AirAvailabilities {
			get {
				return airAvailabilities;
			}
			set {
				this.airAvailabilities = value;
			}
		}

		///
		/// <summary>Accesseurs des disponibilits de la centrale de
		/// rservation automobile associe  cette rservation.</summary>
		///
		public CarAvailability[] CarAvailabilities {
			get {
				return carAvailabilities;
			}
			set {
				this.carAvailabilities = value;
			}
		}

		///
		/// <summary>Accesseurs des disponibilits de la centrale de
		/// rservation htelire associe  cette rservation.</summary>
		///
		public HotelAvailability[] HotelAvailabilities {
			get {
				return hotelAvailabilities;
			}
			set {
				this.hotelAvailabilities = value;
			}
		}

		///
		/// <summary>Accesseurs du nombre de voyageurs.</summary>
		///
		public int Passengers {
			get {
				return passengers;
			}
			set {
				this.passengers = value;
			}
		}

		///
		/// <summary>Accesseurs de la localit de dpart.</summary>
		///
		public String From {
			get {
				return from;
			}
			set {
				this.from = value;
			}
		}

		///
		/// <summary>Accesseurs de la localit d'arrive.</summary>
		///
		public String To {
			get {
				return to;
			}
			set {
				this.to = value;
			}
		}

		///
		/// <summary>Accesseurs du voyage.</summary>
		///
		public bool RoundTrip {
			get {
				return roundTrip;
			}
			set {
				this.roundTrip = value;
			}
		}

		///
		/// <summary>Accesseurs du jour de dpart.</summary>
		///
		public int DepartureDay {
			get {
				return departureDay;
			}
			set {
				this.departureDay = value;
			}
		}

		///
		/// <summary>Accesseurs du mois de dpart.</summary>
		///
		public int DepartureMonth {
			get {
				return departureMonth;
			}
			set {
				this.departureMonth = value;
			}
		}

		///
		/// <summary>Accesseurs de l'anne de dpart.</summary>
		///
		public int DepartureYear {
			get {
				return departureYear;
			}
			set {
				this.departureYear = value;
			}
		}

		///
		/// <summary>Accesseurs du jour de retour.</summary>
		///
		public int ArrivalDay {
			get {
				return arrivalDay;
			}
			set {
				this.arrivalDay = value;
			}
		}

		///
		/// <summary>Accesseurs du mois de retour.</summary>
		///
		public int ArrivalMonth {
			get {
				return arrivalMonth;
			}
			set {
				this.arrivalMonth = value;
			}
		}

		///
		/// <summary>Accesseurs de l'anne de retour.</summary>
		///
		public int ArrivalYear {
			get {
				return arrivalYear;
			}
			set {
				this.arrivalYear = value;
			}
		}

		///
		/// <summary>Renvoie une reprsentation textuelle de la
		/// rservation.</summary> 
		///
		/// <returns>une reprsentation textuelle de la	rservation.
		/// </returns>
		///
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.Append("\r");
			sb.Append(GetType().FullName);
			sb.Append("@");
			sb.Append(System.Convert.ToString(GetHashCode(), 16));
			return sb.ToString();
		}
	}
}